
-- this file gets written automatically by the Archipelago Randomizer and is in its raw form a Jinja2 Template
require('lib')
data.raw["recipe"]["rocket-part"].ingredients = {{"rail", 10},
{"constant-combinator", 10},
{"engine-unit", 10}
}
data.raw["recipe"]["automation-science-pack"].ingredients = {{"coal", 1},
{"copper-cable", 1}
}
data.raw["recipe"]["logistic-science-pack"].ingredients = {{"constant-combinator", 1},
{"iron-stick", 1}
}
data.raw["recipe"]["military-science-pack"].ingredients = {{"firearm-magazine", 1},
{"burner-inserter", 1},
{"pump", 1}
}
data.raw["recipe"]["chemical-science-pack"].ingredients = {{"steam-engine", 1},
{"piercing-shotgun-shell", 1},
{"boiler", 1}
}
data.raw["recipe"]["production-science-pack"].ingredients = {{"hazard-concrete", 1},
{"shotgun-shell", 1},
{"rail", 1}
}
data.raw["recipe"]["utility-science-pack"].ingredients = {{"fast-splitter", 1},
{"grenade", 1},
{"arithmetic-combinator", 1}
}

local technologies = data.raw["technology"]
local original_tech
local new_tree_copy
allowed_ingredients = {}
allowed_ingredients["advanced-electronics"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["advanced-electronics-2"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["advanced-material-processing"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["advanced-material-processing-2"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["advanced-oil-processing"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["artillery"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["atomic-bomb"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["automated-rail-transportation"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["automation"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["automation-2"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["automation-3"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["automobilism"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["battery"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["battery-equipment"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["battery-mk2-equipment"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["belt-immunity-equipment"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["braking-force-1"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["braking-force-2"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["braking-force-3"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["braking-force-4"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["braking-force-5"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["braking-force-6"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["braking-force-7"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["chemical-science-pack"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["circuit-network"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["cliff-explosives"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["coal-liquefaction"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["concrete"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["construction-robotics"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["defender"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["destroyer"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["discharge-defense-equipment"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["distractor"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["effect-transmission"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["effectivity-module"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["effectivity-module-2"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["effectivity-module-3"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["electric-energy-accumulators"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["electric-energy-distribution-1"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["electric-energy-distribution-2"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["electric-engine"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["electronics"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["energy-shield-equipment"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["energy-shield-mk2-equipment"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["energy-weapons-damage-1"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["energy-weapons-damage-2"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["energy-weapons-damage-3"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["energy-weapons-damage-4"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["energy-weapons-damage-5"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["energy-weapons-damage-6"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["engine"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["exoskeleton-equipment"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["explosive-rocketry"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["explosives"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["fast-inserter"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["flamethrower"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["flammables"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["fluid-handling"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["fluid-wagon"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["follower-robot-count-1"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["follower-robot-count-2"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["follower-robot-count-3"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["follower-robot-count-4"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["follower-robot-count-5"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["follower-robot-count-6"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["fusion-reactor-equipment"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["gate"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["gun-turret"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["heavy-armor"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["inserter-capacity-bonus-1"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["inserter-capacity-bonus-2"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["inserter-capacity-bonus-3"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["inserter-capacity-bonus-4"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["inserter-capacity-bonus-5"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["inserter-capacity-bonus-6"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["inserter-capacity-bonus-7"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["kovarex-enrichment-process"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["land-mine"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["landfill"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["laser"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["laser-shooting-speed-1"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["laser-shooting-speed-2"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["laser-shooting-speed-3"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["laser-shooting-speed-4"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["laser-shooting-speed-5"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["laser-shooting-speed-6"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["laser-shooting-speed-7"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["laser-turret"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["logistic-robotics"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["logistic-science-pack"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["logistic-system"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["logistics"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["logistics-2"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["logistics-3"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["low-density-structure"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["lubricant"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["military"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["military-2"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["military-3"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["military-4"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["military-science-pack"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["mining-productivity-1"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["mining-productivity-2"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["mining-productivity-3"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["modular-armor"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["modules"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["night-vision-equipment"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["nuclear-fuel-reprocessing"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["nuclear-power"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["oil-processing"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["optics"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["personal-laser-defense-equipment"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["personal-roboport-equipment"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["personal-roboport-mk2-equipment"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["physical-projectile-damage-1"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["physical-projectile-damage-2"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["physical-projectile-damage-3"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["physical-projectile-damage-4"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["physical-projectile-damage-5"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["physical-projectile-damage-6"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["plastics"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["power-armor"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["power-armor-mk2"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["production-science-pack"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["productivity-module"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["productivity-module-2"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["productivity-module-3"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["rail-signals"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["railway"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["refined-flammables-1"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["refined-flammables-2"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["refined-flammables-3"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["refined-flammables-4"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["refined-flammables-5"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["refined-flammables-6"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["research-speed-1"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["research-speed-2"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["research-speed-3"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["research-speed-4"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["research-speed-5"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["research-speed-6"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["robotics"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["rocket-control-unit"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["rocket-fuel"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["rocket-silo"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["rocketry"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["solar-energy"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["solar-panel-equipment"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["space-science-pack"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["speed-module"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["speed-module-2"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["speed-module-3"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["spidertron"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["stack-inserter"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["steel-axe"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["steel-processing"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["stone-wall"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["stronger-explosives-1"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["stronger-explosives-2"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["stronger-explosives-3"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["stronger-explosives-4"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["stronger-explosives-5"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["stronger-explosives-6"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["sulfur-processing"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["tank"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["toolbelt"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["uranium-ammo"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["uranium-processing"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["utility-science-pack"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["weapon-shooting-speed-1"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["weapon-shooting-speed-2"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["weapon-shooting-speed-3"] = {
["logistic-science-pack"] = 1,
}

allowed_ingredients["weapon-shooting-speed-4"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["weapon-shooting-speed-5"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["weapon-shooting-speed-6"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["worker-robots-speed-1"] = {
["logistic-science-pack"] = 1,
["automation-science-pack"] = 1,
}

allowed_ingredients["worker-robots-speed-2"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["worker-robots-speed-3"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["worker-robots-speed-4"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["worker-robots-speed-5"] = {
["automation-science-pack"] = 1,
}

allowed_ingredients["worker-robots-storage-1"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["worker-robots-storage-2"] = {
["automation-science-pack"] = 1,
["logistic-science-pack"] = 1,
}

allowed_ingredients["worker-robots-storage-3"] = {
["automation-science-pack"] = 1,
}

local template_tech = table.deepcopy(technologies["automation"])
template_tech.unlocks = {}
template_tech.upgrade = false
template_tech.effects = {}
template_tech.prerequisites = {}

function prep_copy(new_copy, old_tech)
    old_tech.hidden = true
    new_copy.unit = table.deepcopy(old_tech.unit)
    local ingredient_filter = allowed_ingredients[old_tech.name]
    if ingredient_filter ~= nil then
        new_copy.unit.ingredients = filter_ingredients(new_copy.unit.ingredients, ingredient_filter)
        new_copy.unit.ingredients = add_ingredients(new_copy.unit.ingredients, ingredient_filter)
    end
end

function set_ap_icon(tech)
    tech.icon = "__AP-W34102213603162363648-P2-Nauvis__/graphics/icons/ap.png"
    tech.icons = nil
    tech.icon_size = 128
end

function set_ap_unimportant_icon(tech)
    tech.icon = "__AP-W34102213603162363648-P2-Nauvis__/graphics/icons/ap_unimportant.png"
    tech.icons = nil
    tech.icon_size = 128
end

function copy_factorio_icon(tech, tech_source)
    tech.icon = table.deepcopy(technologies[tech_source].icon)
    tech.icons = table.deepcopy(technologies[tech_source].icons)
    tech.icon_size = table.deepcopy(technologies[tech_source].icon_size)
end


function adjust_energy(recipe_name, factor)
    local recipe = data.raw.recipe[recipe_name]
    local energy = recipe.energy_required

    if (recipe.normal ~= nil) then
        if (recipe.normal.energy_required == nil) then
            energy = 0.5
        else
            energy = recipe.normal.energy_required
        end
        recipe.normal.energy_required = energy * factor
    end
    if (recipe.expensive ~= nil) then
        if (recipe.expensive.energy_required == nil) then
            energy = 0.5
        else
            energy = recipe.expensive.energy_required
        end
        recipe.expensive.energy_required = energy * factor
    end
    if (energy ~= nil) then
        data.raw.recipe[recipe_name].energy_required = energy * factor
    elseif (recipe.expensive == nil and recipe.normal == nil) then
        data.raw.recipe[recipe_name].energy_required = 0.5 * factor
    end
end

data.raw["assembling-machine"]["assembling-machine-1"].crafting_categories = table.deepcopy(data.raw["assembling-machine"]["assembling-machine-3"].crafting_categories)
data.raw["assembling-machine"]["assembling-machine-2"].crafting_categories = table.deepcopy(data.raw["assembling-machine"]["assembling-machine-3"].crafting_categories)
data.raw["assembling-machine"]["assembling-machine-1"].fluid_boxes = table.deepcopy(data.raw["assembling-machine"]["assembling-machine-2"].fluid_boxes)
data.raw["ammo"]["artillery-shell"].stack_size = 10


original_tech = technologies["advanced-electronics"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131072-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131186-")

table.insert(new_tree_copy.prerequisites, "ap-131122-")


data:extend{new_tree_copy}

original_tech = technologies["advanced-electronics-2"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131073-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["advanced-material-processing"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131074-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["advanced-material-processing-2"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131075-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131197-")

table.insert(new_tree_copy.prerequisites, "ap-131196-")


data:extend{new_tree_copy}

original_tech = technologies["advanced-oil-processing"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131076-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131239-")


data:extend{new_tree_copy}

original_tech = technologies["artillery"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131077-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131203-")


data:extend{new_tree_copy}

original_tech = technologies["atomic-bomb"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131078-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131139-")


data:extend{new_tree_copy}

original_tech = technologies["automated-rail-transportation"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131079-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131096-")


data:extend{new_tree_copy}

original_tech = technologies["automation"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131080-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
copy_factorio_icon(new_tree_copy, "automation")
data:extend{new_tree_copy}

original_tech = technologies["automation-2"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131081-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131120-")

table.insert(new_tree_copy.prerequisites, "ap-131212-")


data:extend{new_tree_copy}

original_tech = technologies["automation-3"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131082-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131182-")


data:extend{new_tree_copy}

original_tech = technologies["automobilism"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131083-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131248-")


data:extend{new_tree_copy}

original_tech = technologies["battery"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131084-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131220-")


data:extend{new_tree_copy}

original_tech = technologies["battery-equipment"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131085-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["battery-mk2-equipment"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131086-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["belt-immunity-equipment"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131087-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131107-")


data:extend{new_tree_copy}

original_tech = technologies["braking-force-1"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131088-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131148-")


data:extend{new_tree_copy}

original_tech = technologies["braking-force-2"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131089-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131145-")

table.insert(new_tree_copy.prerequisites, "ap-131084-")


data:extend{new_tree_copy}

original_tech = technologies["braking-force-3"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131090-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131099-")


data:extend{new_tree_copy}

original_tech = technologies["braking-force-4"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131091-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131232-")


data:extend{new_tree_copy}

original_tech = technologies["braking-force-5"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131092-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131095-")

table.insert(new_tree_copy.prerequisites, "ap-131190-")


data:extend{new_tree_copy}

original_tech = technologies["braking-force-6"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131093-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131244-")


data:extend{new_tree_copy}

original_tech = technologies["braking-force-7"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131094-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131238-")


data:extend{new_tree_copy}

original_tech = technologies["chemical-science-pack"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131095-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131228-")


data:extend{new_tree_copy}

original_tech = technologies["circuit-network"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131096-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["cliff-explosives"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131097-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["coal-liquefaction"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131098-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["concrete"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131099-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["construction-robotics"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131100-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131105-")

table.insert(new_tree_copy.prerequisites, "ap-131094-")


data:extend{new_tree_copy}

original_tech = technologies["defender"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131101-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131074-")


data:extend{new_tree_copy}

original_tech = technologies["destroyer"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131102-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["discharge-defense-equipment"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131103-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131232-")


data:extend{new_tree_copy}

original_tech = technologies["distractor"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131104-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["effect-transmission"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131105-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131238-")


data:extend{new_tree_copy}

original_tech = technologies["effectivity-module"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131106-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131242-")


data:extend{new_tree_copy}

original_tech = technologies["effectivity-module-2"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131107-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["effectivity-module-3"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131108-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131137-")

table.insert(new_tree_copy.prerequisites, "ap-131151-")


data:extend{new_tree_copy}

original_tech = technologies["electric-energy-accumulators"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131109-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131107-")


data:extend{new_tree_copy}

original_tech = technologies["electric-energy-distribution-1"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131110-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131168-")


data:extend{new_tree_copy}

original_tech = technologies["electric-energy-distribution-2"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131111-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131135-")


data:extend{new_tree_copy}

original_tech = technologies["electric-engine"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131112-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131162-")

table.insert(new_tree_copy.prerequisites, "ap-131124-")


data:extend{new_tree_copy}

original_tech = technologies["electronics"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131113-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131168-")


data:extend{new_tree_copy}

original_tech = technologies["energy-shield-equipment"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131114-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131161-")


data:extend{new_tree_copy}

original_tech = technologies["energy-shield-mk2-equipment"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131115-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131194-")


data:extend{new_tree_copy}

original_tech = technologies["energy-weapons-damage-1"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131116-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131171-")


data:extend{new_tree_copy}

original_tech = technologies["energy-weapons-damage-2"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131117-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131115-")

table.insert(new_tree_copy.prerequisites, "ap-131246-")


data:extend{new_tree_copy}

original_tech = technologies["energy-weapons-damage-3"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131118-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131183-")

table.insert(new_tree_copy.prerequisites, "ap-131224-")


data:extend{new_tree_copy}

original_tech = technologies["energy-weapons-damage-4"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131119-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131133-")


data:extend{new_tree_copy}

original_tech = technologies["energy-weapons-damage-5"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131120-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131245-")


data:extend{new_tree_copy}

original_tech = technologies["energy-weapons-damage-6"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131121-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131126-")


data:extend{new_tree_copy}

original_tech = technologies["engine"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131122-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131180-")


data:extend{new_tree_copy}

original_tech = technologies["exoskeleton-equipment"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131123-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131244-")


data:extend{new_tree_copy}

original_tech = technologies["explosive-rocketry"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131124-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131234-")


data:extend{new_tree_copy}

original_tech = technologies["explosives"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131125-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["fast-inserter"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131126-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["flamethrower"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131127-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131079-")

table.insert(new_tree_copy.prerequisites, "ap-131175-")


data:extend{new_tree_copy}

original_tech = technologies["flammables"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131128-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131191-")

table.insert(new_tree_copy.prerequisites, "ap-131106-")


data:extend{new_tree_copy}

original_tech = technologies["fluid-handling"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131129-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["fluid-wagon"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131130-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["follower-robot-count-1"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131131-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131152-")


data:extend{new_tree_copy}

original_tech = technologies["follower-robot-count-2"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131132-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131150-")

table.insert(new_tree_copy.prerequisites, "ap-131077-")


data:extend{new_tree_copy}

original_tech = technologies["follower-robot-count-3"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131133-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["follower-robot-count-4"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131134-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131170-")

table.insert(new_tree_copy.prerequisites, "ap-131116-")


data:extend{new_tree_copy}

original_tech = technologies["follower-robot-count-5"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131135-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["follower-robot-count-6"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131136-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131125-")


data:extend{new_tree_copy}

original_tech = technologies["fusion-reactor-equipment"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131137-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131102-")


data:extend{new_tree_copy}

original_tech = technologies["gate"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131138-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131227-")

table.insert(new_tree_copy.prerequisites, "ap-131178-")


data:extend{new_tree_copy}

original_tech = technologies["gun-turret"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131139-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["heavy-armor"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131140-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["inserter-capacity-bonus-1"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131141-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131201-")

table.insert(new_tree_copy.prerequisites, "ap-131229-")


data:extend{new_tree_copy}

original_tech = technologies["inserter-capacity-bonus-2"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131142-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131103-")

table.insert(new_tree_copy.prerequisites, "ap-131091-")


data:extend{new_tree_copy}

original_tech = technologies["inserter-capacity-bonus-3"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131143-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131148-")


data:extend{new_tree_copy}

original_tech = technologies["inserter-capacity-bonus-4"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131144-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131104-")


data:extend{new_tree_copy}

original_tech = technologies["inserter-capacity-bonus-5"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131145-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131220-")


data:extend{new_tree_copy}

original_tech = technologies["inserter-capacity-bonus-6"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131146-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131123-")

table.insert(new_tree_copy.prerequisites, "ap-131093-")


data:extend{new_tree_copy}

original_tech = technologies["inserter-capacity-bonus-7"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131147-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131199-")

table.insert(new_tree_copy.prerequisites, "ap-131165-")


data:extend{new_tree_copy}

original_tech = technologies["kovarex-enrichment-process"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131148-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["land-mine"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131149-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131158-")

table.insert(new_tree_copy.prerequisites, "ap-131251-")


data:extend{new_tree_copy}

original_tech = technologies["landfill"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131150-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131203-")


data:extend{new_tree_copy}

original_tech = technologies["laser"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131151-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131102-")


data:extend{new_tree_copy}

original_tech = technologies["laser-shooting-speed-1"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131152-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["laser-shooting-speed-2"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131153-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131182-")


data:extend{new_tree_copy}

original_tech = technologies["laser-shooting-speed-3"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131154-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131135-")


data:extend{new_tree_copy}

original_tech = technologies["laser-shooting-speed-4"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131155-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131184-")


data:extend{new_tree_copy}

original_tech = technologies["laser-shooting-speed-5"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131156-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131111-")

table.insert(new_tree_copy.prerequisites, "ap-131154-")


data:extend{new_tree_copy}

original_tech = technologies["laser-shooting-speed-6"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131157-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["laser-shooting-speed-7"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131158-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131140-")


data:extend{new_tree_copy}

original_tech = technologies["laser-turret"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131159-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131241-")


data:extend{new_tree_copy}

original_tech = technologies["logistic-robotics"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131160-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131090-")

table.insert(new_tree_copy.prerequisites, "ap-131217-")


data:extend{new_tree_copy}

original_tech = technologies["logistic-science-pack"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131161-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["logistic-system"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131162-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131234-")


data:extend{new_tree_copy}

original_tech = technologies["logistics"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131163-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
copy_factorio_icon(new_tree_copy, "logistics")
data:extend{new_tree_copy}

original_tech = technologies["logistics-2"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131164-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131098-")


data:extend{new_tree_copy}

original_tech = technologies["logistics-3"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131165-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131226-")


data:extend{new_tree_copy}

original_tech = technologies["low-density-structure"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131166-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131208-")

table.insert(new_tree_copy.prerequisites, "ap-131206-")


data:extend{new_tree_copy}

original_tech = technologies["lubricant"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131167-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131078-")

table.insert(new_tree_copy.prerequisites, "ap-131249-")


data:extend{new_tree_copy}

original_tech = technologies["military"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131168-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["military-2"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131169-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131239-")


data:extend{new_tree_copy}

original_tech = technologies["military-3"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131170-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131171-")


data:extend{new_tree_copy}

original_tech = technologies["military-4"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131171-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["military-science-pack"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131172-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131144-")

table.insert(new_tree_copy.prerequisites, "ap-131211-")


data:extend{new_tree_copy}

original_tech = technologies["mining-productivity-1"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131173-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131126-")


data:extend{new_tree_copy}

original_tech = technologies["mining-productivity-2"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131174-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131133-")


data:extend{new_tree_copy}

original_tech = technologies["mining-productivity-3"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131175-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131096-")


data:extend{new_tree_copy}

original_tech = technologies["modular-armor"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131176-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["modules"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131177-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131181-")


data:extend{new_tree_copy}

original_tech = technologies["night-vision-equipment"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131178-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131214-")


data:extend{new_tree_copy}

original_tech = technologies["nuclear-fuel-reprocessing"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131179-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131131-")

table.insert(new_tree_copy.prerequisites, "ap-131205-")


data:extend{new_tree_copy}

original_tech = technologies["nuclear-power"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131180-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["oil-processing"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131181-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["optics"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131182-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["personal-laser-defense-equipment"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131183-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131176-")


data:extend{new_tree_copy}

original_tech = technologies["personal-roboport-equipment"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131184-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["personal-roboport-mk2-equipment"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131185-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131155-")

table.insert(new_tree_copy.prerequisites, "ap-131231-")


data:extend{new_tree_copy}

original_tech = technologies["physical-projectile-damage-1"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131186-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131180-")


data:extend{new_tree_copy}

original_tech = technologies["physical-projectile-damage-2"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131187-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131241-")


data:extend{new_tree_copy}

original_tech = technologies["physical-projectile-damage-3"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131188-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131247-")

table.insert(new_tree_copy.prerequisites, "ap-131083-")


data:extend{new_tree_copy}

original_tech = technologies["physical-projectile-damage-4"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131189-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131164-")

table.insert(new_tree_copy.prerequisites, "ap-131202-")


data:extend{new_tree_copy}

original_tech = technologies["physical-projectile-damage-5"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131190-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131228-")


data:extend{new_tree_copy}

original_tech = technologies["physical-projectile-damage-6"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131191-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131242-")


data:extend{new_tree_copy}

original_tech = technologies["plastics"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131192-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131174-")

table.insert(new_tree_copy.prerequisites, "ap-131119-")


data:extend{new_tree_copy}

original_tech = technologies["power-armor"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131193-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131161-")


data:extend{new_tree_copy}

original_tech = technologies["power-armor-mk2"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131194-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["production-science-pack"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131195-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["productivity-module"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131196-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131130-")


data:extend{new_tree_copy}

original_tech = technologies["productivity-module-2"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131197-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131130-")


data:extend{new_tree_copy}

original_tech = technologies["productivity-module-3"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131198-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131181-")


data:extend{new_tree_copy}

original_tech = technologies["rail-signals"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131199-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131226-")


data:extend{new_tree_copy}

original_tech = technologies["railway"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131200-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131125-")


data:extend{new_tree_copy}

original_tech = technologies["refined-flammables-1"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131201-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131195-")


data:extend{new_tree_copy}

original_tech = technologies["refined-flammables-2"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131202-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131098-")


data:extend{new_tree_copy}

original_tech = technologies["refined-flammables-3"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131203-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["refined-flammables-4"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131204-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131243-")

table.insert(new_tree_copy.prerequisites, "ap-131101-")


data:extend{new_tree_copy}

original_tech = technologies["refined-flammables-5"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131205-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131152-")


data:extend{new_tree_copy}

original_tech = technologies["refined-flammables-6"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131206-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131129-")


data:extend{new_tree_copy}

original_tech = technologies["research-speed-1"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131207-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131233-")


data:extend{new_tree_copy}

original_tech = technologies["research-speed-2"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131208-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131129-")


data:extend{new_tree_copy}

original_tech = technologies["research-speed-3"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131209-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131143-")

table.insert(new_tree_copy.prerequisites, "ap-131088-")


data:extend{new_tree_copy}

original_tech = technologies["research-speed-4"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131210-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131076-")

table.insert(new_tree_copy.prerequisites, "ap-131169-")


data:extend{new_tree_copy}

original_tech = technologies["research-speed-5"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131211-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131104-")


data:extend{new_tree_copy}

original_tech = technologies["research-speed-6"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131212-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131245-")


data:extend{new_tree_copy}

original_tech = technologies["robotics"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131213-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131121-")

table.insert(new_tree_copy.prerequisites, "ap-131173-")


data:extend{new_tree_copy}

original_tech = technologies["rocket-control-unit"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131214-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["rocket-fuel"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131215-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131207-")

table.insert(new_tree_copy.prerequisites, "ap-131253-")


data:extend{new_tree_copy}

original_tech = technologies["rocket-silo"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131216-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
copy_factorio_icon(new_tree_copy, "rocket-silo")
table.insert(new_tree_copy.effects, {type = "nothing", effect_description = "Ingredient 1: rail"})

table.insert(new_tree_copy.effects, {type = "nothing", effect_description = "Ingredient 2: constant-combinator"})

table.insert(new_tree_copy.effects, {type = "nothing", effect_description = "Ingredient 3: engine-unit"})

data:extend{new_tree_copy}

original_tech = technologies["rocketry"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131217-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131099-")


data:extend{new_tree_copy}

original_tech = technologies["solar-energy"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131218-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131136-")

table.insert(new_tree_copy.prerequisites, "ap-131200-")


data:extend{new_tree_copy}

original_tech = technologies["solar-panel-equipment"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131219-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131109-")

table.insert(new_tree_copy.prerequisites, "ap-131087-")


data:extend{new_tree_copy}

original_tech = technologies["space-science-pack"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131220-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["speed-module"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131221-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131085-")


data:extend{new_tree_copy}

original_tech = technologies["speed-module-2"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131222-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131254-")


data:extend{new_tree_copy}

original_tech = technologies["speed-module-3"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131223-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131085-")


data:extend{new_tree_copy}

original_tech = technologies["spidertron"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131224-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131176-")


data:extend{new_tree_copy}

original_tech = technologies["stack-inserter"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131225-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131113-")

table.insert(new_tree_copy.prerequisites, "ap-131110-")


data:extend{new_tree_copy}

original_tech = technologies["steel-axe"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131226-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["steel-processing"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131227-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131214-")


data:extend{new_tree_copy}

original_tech = technologies["stone-wall"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131228-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["stronger-explosives-1"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131229-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131195-")


data:extend{new_tree_copy}

original_tech = technologies["stronger-explosives-2"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131230-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131153-")

table.insert(new_tree_copy.prerequisites, "ap-131082-")


data:extend{new_tree_copy}

original_tech = technologies["stronger-explosives-3"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131231-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131184-")


data:extend{new_tree_copy}

original_tech = technologies["stronger-explosives-4"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131232-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["stronger-explosives-5"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131233-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["stronger-explosives-6"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131234-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["sulfur-processing"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131235-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131250-")

table.insert(new_tree_copy.prerequisites, "ap-131222-")


data:extend{new_tree_copy}

original_tech = technologies["tank"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131236-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131193-")

table.insert(new_tree_copy.prerequisites, "ap-131114-")


data:extend{new_tree_copy}

original_tech = technologies["toolbelt"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131237-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131177-")

table.insert(new_tree_copy.prerequisites, "ap-131198-")


data:extend{new_tree_copy}

original_tech = technologies["uranium-ammo"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131238-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["uranium-processing"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131239-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["utility-science-pack"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131240-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131187-")

table.insert(new_tree_copy.prerequisites, "ap-131159-")


data:extend{new_tree_copy}

original_tech = technologies["weapon-shooting-speed-1"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131241-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["weapon-shooting-speed-2"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131242-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["weapon-shooting-speed-3"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131243-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131074-")


data:extend{new_tree_copy}

original_tech = technologies["weapon-shooting-speed-4"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131244-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["weapon-shooting-speed-5"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131245-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["weapon-shooting-speed-6"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131246-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131194-")


data:extend{new_tree_copy}

original_tech = technologies["worker-robots-speed-1"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131247-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131248-")


data:extend{new_tree_copy}

original_tech = technologies["worker-robots-speed-2"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131248-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_icon(new_tree_copy)
data:extend{new_tree_copy}

original_tech = technologies["worker-robots-speed-3"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131249-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131139-")


data:extend{new_tree_copy}

original_tech = technologies["worker-robots-speed-4"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131250-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131254-")


data:extend{new_tree_copy}

original_tech = technologies["worker-robots-speed-5"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131251-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131140-")


data:extend{new_tree_copy}

original_tech = technologies["worker-robots-storage-1"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131252-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131221-")

table.insert(new_tree_copy.prerequisites, "ap-131223-")


data:extend{new_tree_copy}

original_tech = technologies["worker-robots-storage-2"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131253-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
table.insert(new_tree_copy.prerequisites, "ap-131233-")


data:extend{new_tree_copy}

original_tech = technologies["worker-robots-storage-3"]
new_tree_copy = table.deepcopy(template_tech)
new_tree_copy.name = "ap-131254-"
prep_copy(new_tree_copy, original_tech)

new_tree_copy.unit.count = math.max(1, math.floor(new_tree_copy.unit.count * 0.5))
set_ap_unimportant_icon(new_tree_copy)
data:extend{new_tree_copy}


adjust_energy("accumulator", 1.777889962671352)
adjust_energy("advanced-circuit", 1.1501071424851368)
adjust_energy("arithmetic-combinator", 1.3800052766017605)
adjust_energy("artillery-shell", 0.5)
adjust_energy("artillery-targeting-remote", 0.5)
adjust_energy("artillery-turret", 1.548493374161985)
adjust_energy("artillery-wagon", 1.2179332121867315)
adjust_energy("assembling-machine-1", 0.5)
adjust_energy("assembling-machine-2", 0.5)
adjust_energy("assembling-machine-3", 1.022628329840752)
adjust_energy("atomic-bomb", 1.4979626094821046)
adjust_energy("automation-science-pack", 0.5)
adjust_energy("battery", 1.2530901400122934)
adjust_energy("battery-equipment", 0.8582340856453152)
adjust_energy("battery-mk2-equipment", 0.5)
adjust_energy("beacon", 1.3463696388287072)
adjust_energy("belt-immunity-equipment", 1.726174011384758)
adjust_energy("big-electric-pole", 0.5)
adjust_energy("boiler", 0.8472049456376203)
adjust_energy("burner-inserter", 0.9194756093354868)
adjust_energy("burner-mining-drill", 0.5)
adjust_energy("cannon-shell", 1.5444130460074366)
adjust_energy("car", 0.5)
adjust_energy("cargo-wagon", 0.5)
adjust_energy("centrifuge", 1.005319200901773)
adjust_energy("chemical-plant", 1.5113974275576407)
adjust_energy("chemical-science-pack", 1.1356564683298342)
adjust_energy("cliff-explosives", 0.5)
adjust_energy("cluster-grenade", 1.149080097474472)
adjust_energy("combat-shotgun", 0.5)
adjust_energy("concrete", 1.3596818958590444)
adjust_energy("constant-combinator", 1.4336924221446754)
adjust_energy("construction-robot", 0.9826798525879803)
adjust_energy("copper-cable", 1.7047769566665343)
adjust_energy("copper-plate", 0.5)
adjust_energy("decider-combinator", 0.5)
adjust_energy("defender-capsule", 1.9113775600130993)
adjust_energy("destroyer-capsule", 0.5)
adjust_energy("discharge-defense-equipment", 1.5235715246300727)
adjust_energy("discharge-defense-remote", 0.5)
adjust_energy("distractor-capsule", 1.4120725988857203)
adjust_energy("effectivity-module", 1.2418787328201049)
adjust_energy("effectivity-module-2", 1.4015782590307335)
adjust_energy("effectivity-module-3", 1.0175579622255326)
adjust_energy("electric-engine-unit", 1.3698535693014315)
adjust_energy("electric-furnace", 0.8148885338042338)
adjust_energy("electric-mining-drill", 0.5872533888298039)
adjust_energy("electronic-circuit", 0.5901480232590218)
adjust_energy("empty-barrel", 0.5)
adjust_energy("energy-shield-equipment", 0.5)
adjust_energy("energy-shield-mk2-equipment", 1.085272560258601)
adjust_energy("engine-unit", 1.0610036359336483)
adjust_energy("exoskeleton-equipment", 0.5)
adjust_energy("explosive-cannon-shell", 0.8390466851428089)
adjust_energy("explosive-rocket", 1.4080747421320525)
adjust_energy("explosive-uranium-cannon-shell", 0.8024316387906204)
adjust_energy("explosives", 0.861402812035535)
adjust_energy("express-splitter", 1.5380886420808888)
adjust_energy("express-transport-belt", 0.5)
adjust_energy("express-underground-belt", 0.5)
adjust_energy("fast-inserter", 0.5)
adjust_energy("fast-splitter", 0.7604595164876091)
adjust_energy("fast-transport-belt", 1.8919743580042239)
adjust_energy("fast-underground-belt", 0.8493960014184732)
adjust_energy("filter-inserter", 1.873509873031457)
adjust_energy("firearm-magazine", 0.6608062293127164)
adjust_energy("flamethrower", 1.7525805527388643)
adjust_energy("flamethrower-ammo", 0.5)
adjust_energy("flamethrower-turret", 0.5)
adjust_energy("fluid-wagon", 0.96253204842219)
adjust_energy("flying-robot-frame", 0.5)
adjust_energy("fusion-reactor-equipment", 0.5707056503645136)
adjust_energy("gate", 0.5929573181677403)
adjust_energy("green-wire", 0.7637429617393641)
adjust_energy("grenade", 1.0147542207228333)
adjust_energy("gun-turret", 0.5)
adjust_energy("hazard-concrete", 1.770126828252569)
adjust_energy("heat-exchanger", 1.4794641871809695)
adjust_energy("heat-pipe", 0.5)
adjust_energy("heavy-armor", 0.5)
adjust_energy("inserter", 0.5)
adjust_energy("iron-chest", 1.7139255470360917)
adjust_energy("iron-gear-wheel", 0.5)
adjust_energy("iron-plate", 1.5903927054224933)
adjust_energy("iron-stick", 1.6887406741003335)
adjust_energy("lab", 1.838721134586282)
adjust_energy("land-mine", 0.5)
adjust_energy("landfill", 0.5)
adjust_energy("laser-turret", 0.5)
adjust_energy("light-armor", 0.5)
adjust_energy("locomotive", 1.1017882618409627)
adjust_energy("logistic-chest-active-provider", 1.3725696171243995)
adjust_energy("logistic-chest-buffer", 0.5)
adjust_energy("logistic-chest-passive-provider", 0.5168260338759487)
adjust_energy("logistic-chest-requester", 1.7211671121796934)
adjust_energy("logistic-chest-storage", 0.9632988428409788)
adjust_energy("logistic-robot", 0.7983780050048546)
adjust_energy("logistic-science-pack", 0.5932432433691535)
adjust_energy("long-handed-inserter", 1.9184770453001139)
adjust_energy("low-density-structure", 0.5)
adjust_energy("lubricant", 0.5)
adjust_energy("medium-electric-pole", 1.18082646652131)
adjust_energy("military-science-pack", 0.7222403710785299)
adjust_energy("modular-armor", 0.5)
adjust_energy("night-vision-equipment", 0.5)
adjust_energy("nuclear-fuel", 1.7185820094962638)
adjust_energy("nuclear-reactor", 0.5)
adjust_energy("offshore-pump", 0.9023125308314257)
adjust_energy("oil-refinery", 0.5)
adjust_energy("personal-laser-defense-equipment", 0.7762300201428535)
adjust_energy("personal-roboport-equipment", 0.5)
adjust_energy("personal-roboport-mk2-equipment", 1.6104666545539164)
adjust_energy("piercing-rounds-magazine", 0.5)
adjust_energy("piercing-shotgun-shell", 0.5)
adjust_energy("pipe", 0.5)
adjust_energy("pipe-to-ground", 0.5)
adjust_energy("pistol", 0.5)
adjust_energy("plastic-bar", 0.5)
adjust_energy("poison-capsule", 1.414435339582223)
adjust_energy("power-armor", 1.918923786796803)
adjust_energy("power-armor-mk2", 1.9146481319162232)
adjust_energy("power-switch", 0.5)
adjust_energy("processing-unit", 0.6894716026751718)
adjust_energy("production-science-pack", 1.7760502063064814)
adjust_energy("productivity-module", 0.5)
adjust_energy("productivity-module-2", 1.0357776683975248)
adjust_energy("productivity-module-3", 0.6886584526534596)
adjust_energy("programmable-speaker", 0.5709390907452663)
adjust_energy("pump", 0.848838311664692)
adjust_energy("pumpjack", 0.5)
adjust_energy("radar", 1.5684172207491966)
adjust_energy("rail", 0.5447388876761133)
adjust_energy("rail-chain-signal", 0.5)
adjust_energy("rail-signal", 0.5)
adjust_energy("red-wire", 0.5)
adjust_energy("refined-concrete", 0.5)
adjust_energy("refined-hazard-concrete", 0.5)
adjust_energy("repair-pack", 1.5620483884785492)
adjust_energy("roboport", 0.5)
adjust_energy("rocket", 0.5)
adjust_energy("rocket-control-unit", 0.5)
adjust_energy("rocket-fuel", 0.5)
adjust_energy("rocket-launcher", 0.5)
adjust_energy("rocket-part", 0.5)
adjust_energy("rocket-silo", 1.9007499474903105)
adjust_energy("satellite", 0.5)
adjust_energy("shotgun", 0.5)
adjust_energy("shotgun-shell", 0.5)
adjust_energy("slowdown-capsule", 0.7103283642008611)
adjust_energy("small-electric-pole", 0.5647584795491117)
adjust_energy("small-lamp", 0.5)
adjust_energy("solar-panel", 1.6257436249085262)
adjust_energy("solar-panel-equipment", 0.5)
adjust_energy("speed-module", 0.5)
adjust_energy("speed-module-2", 0.5)
adjust_energy("speed-module-3", 0.5)
adjust_energy("spidertron", 0.889121068727557)
adjust_energy("spidertron-remote", 0.5)
adjust_energy("splitter", 0.5)
adjust_energy("stack-filter-inserter", 0.5)
adjust_energy("stack-inserter", 0.5)
adjust_energy("steam-engine", 0.5)
adjust_energy("steam-turbine", 1.2894975092042116)
adjust_energy("steel-chest", 0.9965716347584607)
adjust_energy("steel-furnace", 0.5)
adjust_energy("steel-plate", 0.5)
adjust_energy("stone-brick", 0.7883620452674565)
adjust_energy("stone-furnace", 0.8657048675279202)
adjust_energy("stone-wall", 0.5132602820287246)
adjust_energy("storage-tank", 0.821124923739545)
adjust_energy("submachine-gun", 0.5)
adjust_energy("substation", 0.5)
adjust_energy("sulfur", 0.5)
adjust_energy("sulfuric-acid", 0.5)
adjust_energy("tank", 0.5)
adjust_energy("train-stop", 1.4397180664949014)
adjust_energy("transport-belt", 0.5)
adjust_energy("underground-belt", 1.643923078110857)
adjust_energy("uranium-cannon-shell", 1.1387011103486302)
adjust_energy("uranium-fuel-cell", 0.5660414308058741)
adjust_energy("uranium-rounds-magazine", 0.5)
adjust_energy("utility-science-pack", 1.748806963205565)
adjust_energy("wooden-chest", 1.481093647215785)
adjust_energy("basic-oil-processing", 0.5028022848908054)
adjust_energy("advanced-oil-processing", 1.5818650756204884)
adjust_energy("coal-liquefaction", 1.3081371373621944)
adjust_energy("fill-crude-oil-barrel", 0.6133832845577603)
adjust_energy("fill-heavy-oil-barrel", 0.5)
adjust_energy("fill-light-oil-barrel", 1.4373231813899843)
adjust_energy("fill-lubricant-barrel", 1.3921198028284332)
adjust_energy("fill-petroleum-gas-barrel", 0.5)
adjust_energy("fill-sulfuric-acid-barrel", 0.5)
adjust_energy("fill-water-barrel", 1.5407016616076517)
adjust_energy("heavy-oil-cracking", 0.5)
adjust_energy("light-oil-cracking", 0.5)
adjust_energy("solid-fuel-from-light-oil", 0.5)
adjust_energy("solid-fuel-from-petroleum-gas", 0.5)
adjust_energy("solid-fuel-from-heavy-oil", 1.1370859705051866)
adjust_energy("empty-crude-oil-barrel", 0.5)
adjust_energy("empty-heavy-oil-barrel", 1.6172421754377848)
adjust_energy("empty-light-oil-barrel", 0.5)
adjust_energy("empty-lubricant-barrel", 0.5760318528349115)
adjust_energy("empty-petroleum-gas-barrel", 0.5)
adjust_energy("empty-sulfuric-acid-barrel", 0.5)
adjust_energy("empty-water-barrel", 1.5680957757257727)
adjust_energy("uranium-processing", 0.5)
adjust_energy("nuclear-fuel-reprocessing", 1.9180922822032764)
adjust_energy("kovarex-enrichment-process", 0.5857273504997493)